

<?php $__env->startSection('title', 'Account Login'); ?>
<?php $__env->startSection('content'); ?>

<div class="flex flex-col lg:flex-row min-h-screen">
    <!-- Left Side - Branding & Illustration (Desktop Only) -->
    <div class="hidden lg:flex lg:w-1/2 bg-gradient-to-br from-primary-600 to-primary-800 relative overflow-hidden">
        <!-- Animated Shapes -->
        <div class="absolute inset-0 overflow-hidden opacity-10">
            <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-white rounded-full mix-blend-overlay floating-slow"></div>
            <div class="absolute bottom-1/3 right-1/4 w-96 h-96 bg-white rounded-full mix-blend-overlay floating"></div>
            <div class="absolute top-2/3 left-1/3 w-40 h-40 bg-white rounded-full mix-blend-overlay floating-slower"></div>
            
            <!-- Grid pattern -->
            <div class="absolute inset-0" style="background-image: radial-gradient(rgba(255,255,255,0.1) 1px, transparent 1px); background-size: 20px 20px;"></div>
        </div>
        
        <!-- Content -->
        <div class="relative flex flex-col justify-center items-center w-full h-full text-white p-12 z-10">
            <!-- Logo -->
            <a href="/" class="mb-6">
                <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="Logo" class="h-16 filter brightness-0 invert">
            </a>
            
            <!-- Title -->
            <h1 class="text-4xl font-extrabold mb-6 text-center">Swift Money Transfer</h1>
            
            <!-- Description -->
            <p class="text-xl mb-8 max-w-md text-center text-white/80">
                Swift and Secure Money Transfer to any bank account will become a breeze with <?php echo e($settings->site_name); ?>.
            </p>
            
            <!-- Features -->
            <div class="grid grid-cols-2 gap-6 w-full max-w-md">
                <div class="flex items-center space-x-3">
                    <div class="flex-shrink-0 w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                        <i data-lucide="shield" class="h-5 w-5"></i>
                    </div>
                    <span>Secure Transfers</span>
                </div>
                <div class="flex items-center space-x-3">
                    <div class="flex-shrink-0 w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                        <i data-lucide="zap" class="h-5 w-5"></i>
                    </div>
                    <span>Lightning Fast</span>
                </div>
                <div class="flex items-center space-x-3">
                    <div class="flex-shrink-0 w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                        <i data-lucide="globe" class="h-5 w-5"></i>
                    </div>
                    <span>Global Access</span>
                </div>
                <div class="flex items-center space-x-3">
                    <div class="flex-shrink-0 w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                        <i data-lucide="smartphone" class="h-5 w-5"></i>
                    </div>
                    <span>Mobile Ready</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Side - Login Form -->
    <div class="w-full lg:w-1/2 flex flex-col justify-center items-center p-6 lg:p-12">
        <div class="w-full max-w-md">
            <!-- Mobile Logo -->
            <div class="lg:hidden text-center mb-8">
                <a href="/">
                    <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="Logo" class="h-12 mx-auto">
                </a>
            </div>
            
            <!-- Alerts -->
            <?php if(Session::has('status')): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded" role="alert">
                    <p><?php echo e(session('status')); ?></p>
                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded" role="alert">
                    <ul class="list-disc list-inside">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            
            <!-- Login Card -->
            <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                <!-- Card Header -->
                <div class="px-8 pt-8 pb-6">
                    <h2 class="text-2xl font-bold text-gray-900">Sign In to <?php echo e($settings->site_name); ?></h2>
                    <p class="mt-2 text-sm text-gray-600">Access the <?php echo e($settings->site_name); ?> panel using your email and password.</p>
                </div>
                
                <!-- Login Form -->
                <div class="px-8 pb-8">
                    <form method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Email -->
                        <div class="mb-6">
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                            <div class="input-wrapper">
                                <div class="relative">
                                    <div class="input-icon">
                                        <i data-lucide="mail" class="h-5 w-5"></i>
                                    </div>
                                    <input 
                                        id="email"
                                        type="email" 
                                        name="email" 
                                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500" 
                                        placeholder="name@email.com"
                                        required 
                                        autocomplete="email">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Password -->
                        <div class="mb-6">
                            <div class="flex items-center justify-between mb-2">
                                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                                <a href="<?php echo e(route('password.request')); ?>" class="text-sm text-primary-600 hover:text-primary-500">
                                    Forgot Password?
                                </a>
                            </div>
                            <div class="input-wrapper">
                                <div class="relative">
                                    <div class="input-icon">
                                        <i data-lucide="lock" class="h-5 w-5"></i>
                                    </div>
                                    <input 
                                        id="password"
                                        type="password" 
                                        name="password"
                                        class="w-full pl-10 pr-12 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-primary-500" 
                                        placeholder="••••••••"
                                        required
                                        autocomplete="current-password">
                                    <button 
                                        type="button"
                                        onclick="togglePasswordVisibility()"
                                        class="absolute inset-y-0 right-0 flex items-center pr-3 input-toggle">
                                        <i data-lucide="eye" id="show-password" class="h-5 w-5 text-gray-400"></i>
                                        <i data-lucide="eye-off" id="hide-password" class="h-5 w-5 text-gray-400 hidden"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Remember Me -->
                        <div class="mb-6">
                            <label class="inline-flex items-center">
                                <input 
                                    type="checkbox" 
                                    name="remember_me"
                                    class="rounded border-gray-300 text-primary-600 shadow-sm focus:border-primary-300 focus:ring focus:ring-primary-200 focus:ring-opacity-50" 
                                    checked>
                                <span class="ml-2 text-sm text-gray-600">Stay signed in for 30 days</span>
                            </label>
                        </div>
                        
                        <!-- Buttons -->
                        <div class="flex flex-col space-y-4">
                            <button 
                                type="submit"
                                class="w-full py-3 px-4 bg-primary-600 hover:bg-primary-700 text-white font-medium rounded-lg shadow transition duration-150 ease-in-out flex items-center justify-center">
                                <i data-lucide="log-in" class="h-5 w-5 mr-2"></i>
                                Sign In
                            </button>
                            
                            <a 
                                href="<?php echo e(route('register')); ?>"
                                class="w-full py-3 px-4 bg-gray-100 hover:bg-gray-200 text-gray-800 font-medium rounded-lg transition duration-150 ease-in-out flex items-center justify-center">
                                <i data-lucide="user-plus" class="h-5 w-5 mr-2"></i>
                                Not enrolled? Create Account
                            </a>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Additional Links -->
            <div class="mt-8 text-center">
                <p class="text-sm text-gray-600">
                    By signing in, you agree to our 
                    <a href="#" class="text-primary-600 hover:text-primary-500">Terms of Service</a> and 
                    <a href="#" class="text-primary-600 hover:text-primary-500">Privacy Policy</a>
                </p>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function togglePasswordVisibility() {
        const passwordInput = document.getElementById('password');
        const showPasswordIcon = document.getElementById('show-password');
        const hidePasswordIcon = document.getElementById('hide-password');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            showPasswordIcon.classList.add('hidden');
            hidePasswordIcon.classList.remove('hidden');
        } else {
            passwordInput.type = 'password';
            showPasswordIcon.classList.remove('hidden');
            hidePasswordIcon.classList.add('hidden');
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.guest2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/burlingm/grand.burlingmail.click/resources/views/auth/login.blade.php ENDPATH**/ ?>