<?php
// This file was auto-generated from sdk-root/src/data/amplifyuibuilder/2021-08-11/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2021-08-11', 'endpointPrefix' => 'amplifyuibuilder', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS Amplify UI Builder', 'serviceId' => 'AmplifyUIBuilder', 'signatureVersion' => 'v4', 'signingName' => 'amplifyuibuilder', 'uid' => 'amplifyuibuilder-2021-08-11', ], 'operations' => [ 'CreateComponent' => [ 'name' => 'CreateComponent', 'http' => [ 'method' => 'POST', 'requestUri' => '/app/{appId}/environment/{environmentName}/components', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateComponentRequest', ], 'output' => [ 'shape' => 'CreateComponentResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], 'idempotent' => true, ], 'CreateForm' => [ 'name' => 'CreateForm', 'http' => [ 'method' => 'POST', 'requestUri' => '/app/{appId}/environment/{environmentName}/forms', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateFormRequest', ], 'output' => [ 'shape' => 'CreateFormResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], 'idempotent' => true, ], 'CreateTheme' => [ 'name' => 'CreateTheme', 'http' => [ 'method' => 'POST', 'requestUri' => '/app/{appId}/environment/{environmentName}/themes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateThemeRequest', ], 'output' => [ 'shape' => 'CreateThemeResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], 'idempotent' => true, ], 'DeleteComponent' => [ 'name' => 'DeleteComponent', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/app/{appId}/environment/{environmentName}/components/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteComponentRequest', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteForm' => [ 'name' => 'DeleteForm', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/app/{appId}/environment/{environmentName}/forms/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteFormRequest', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteTheme' => [ 'name' => 'DeleteTheme', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/app/{appId}/environment/{environmentName}/themes/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteThemeRequest', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'ExchangeCodeForToken' => [ 'name' => 'ExchangeCodeForToken', 'http' => [ 'method' => 'POST', 'requestUri' => '/tokens/{provider}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ExchangeCodeForTokenRequest', ], 'output' => [ 'shape' => 'ExchangeCodeForTokenResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], ], ], 'ExportComponents' => [ 'name' => 'ExportComponents', 'http' => [ 'method' => 'GET', 'requestUri' => '/export/app/{appId}/environment/{environmentName}/components', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ExportComponentsRequest', ], 'output' => [ 'shape' => 'ExportComponentsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ExportForms' => [ 'name' => 'ExportForms', 'http' => [ 'method' => 'GET', 'requestUri' => '/export/app/{appId}/environment/{environmentName}/forms', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ExportFormsRequest', ], 'output' => [ 'shape' => 'ExportFormsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ExportThemes' => [ 'name' => 'ExportThemes', 'http' => [ 'method' => 'GET', 'requestUri' => '/export/app/{appId}/environment/{environmentName}/themes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ExportThemesRequest', ], 'output' => [ 'shape' => 'ExportThemesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'GetComponent' => [ 'name' => 'GetComponent', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/components/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetComponentRequest', ], 'output' => [ 'shape' => 'GetComponentResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetForm' => [ 'name' => 'GetForm', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/forms/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFormRequest', ], 'output' => [ 'shape' => 'GetFormResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'GetMetadata' => [ 'name' => 'GetMetadata', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/metadata', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMetadataRequest', ], 'output' => [ 'shape' => 'GetMetadataResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'GetTheme' => [ 'name' => 'GetTheme', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/themes/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetThemeRequest', ], 'output' => [ 'shape' => 'GetThemeResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListComponents' => [ 'name' => 'ListComponents', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/components', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListComponentsRequest', ], 'output' => [ 'shape' => 'ListComponentsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ListForms' => [ 'name' => 'ListForms', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/forms', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFormsRequest', ], 'output' => [ 'shape' => 'ListFormsResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'ListThemes' => [ 'name' => 'ListThemes', 'http' => [ 'method' => 'GET', 'requestUri' => '/app/{appId}/environment/{environmentName}/themes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListThemesRequest', ], 'output' => [ 'shape' => 'ListThemesResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'PutMetadataFlag' => [ 'name' => 'PutMetadataFlag', 'http' => [ 'method' => 'PUT', 'requestUri' => '/app/{appId}/environment/{environmentName}/metadata/features/{featureName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutMetadataFlagRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'InvalidParameterException', ], ], ], 'RefreshToken' => [ 'name' => 'RefreshToken', 'http' => [ 'method' => 'POST', 'requestUri' => '/tokens/{provider}/refresh', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RefreshTokenRequest', ], 'output' => [ 'shape' => 'RefreshTokenResponse', ], 'errors' => [ [ 'shape' => 'InvalidParameterException', ], ], ], 'UpdateComponent' => [ 'name' => 'UpdateComponent', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/app/{appId}/environment/{environmentName}/components/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateComponentRequest', ], 'output' => [ 'shape' => 'UpdateComponentResponse', ], 'errors' => [ [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], 'idempotent' => true, ], 'UpdateForm' => [ 'name' => 'UpdateForm', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/app/{appId}/environment/{environmentName}/forms/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateFormRequest', ], 'output' => [ 'shape' => 'UpdateFormResponse', ], 'errors' => [ [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], 'idempotent' => true, ], 'UpdateTheme' => [ 'name' => 'UpdateTheme', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/app/{appId}/environment/{environmentName}/themes/{id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateThemeRequest', ], 'output' => [ 'shape' => 'UpdateThemeResponse', ], 'errors' => [ [ 'shape' => 'ResourceConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'InvalidParameterException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'ActionParameters' => [ 'type' => 'structure', 'members' => [ 'anchor' => [ 'shape' => 'ComponentProperty', ], 'fields' => [ 'shape' => 'ComponentProperties', ], 'global' => [ 'shape' => 'ComponentProperty', ], 'id' => [ 'shape' => 'ComponentProperty', ], 'model' => [ 'shape' => 'String', ], 'state' => [ 'shape' => 'MutationActionSetStateParameter', ], 'target' => [ 'shape' => 'ComponentProperty', ], 'type' => [ 'shape' => 'ComponentProperty', ], 'url' => [ 'shape' => 'ComponentProperty', ], ], ], 'Boolean' => [ 'type' => 'boolean', ], 'Component' => [ 'type' => 'structure', 'required' => [ 'appId', 'bindingProperties', 'componentType', 'createdAt', 'environmentName', 'id', 'name', 'overrides', 'properties', 'variants', ], 'members' => [ 'appId' => [ 'shape' => 'String', ], 'bindingProperties' => [ 'shape' => 'ComponentBindingProperties', ], 'children' => [ 'shape' => 'ComponentChildList', ], 'collectionProperties' => [ 'shape' => 'ComponentCollectionProperties', ], 'componentType' => [ 'shape' => 'ComponentType', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'environmentName' => [ 'shape' => 'String', ], 'events' => [ 'shape' => 'ComponentEvents', ], 'id' => [ 'shape' => 'Uuid', ], 'modifiedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'ComponentName', ], 'overrides' => [ 'shape' => 'ComponentOverrides', ], 'properties' => [ 'shape' => 'ComponentProperties', ], 'schemaVersion' => [ 'shape' => 'String', ], 'sourceId' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'Tags', ], 'variants' => [ 'shape' => 'ComponentVariants', ], ], ], 'ComponentBindingProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ComponentBindingPropertiesValue', ], ], 'ComponentBindingPropertiesValue' => [ 'type' => 'structure', 'members' => [ 'bindingProperties' => [ 'shape' => 'ComponentBindingPropertiesValueProperties', ], 'defaultValue' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], ], ], 'ComponentBindingPropertiesValueProperties' => [ 'type' => 'structure', 'members' => [ 'bucket' => [ 'shape' => 'String', ], 'defaultValue' => [ 'shape' => 'String', ], 'field' => [ 'shape' => 'String', ], 'key' => [ 'shape' => 'String', ], 'model' => [ 'shape' => 'String', ], 'predicates' => [ 'shape' => 'PredicateList', ], 'slotName' => [ 'shape' => 'String', ], 'userAttribute' => [ 'shape' => 'String', ], ], ], 'ComponentChild' => [ 'type' => 'structure', 'required' => [ 'componentType', 'name', 'properties', ], 'members' => [ 'children' => [ 'shape' => 'ComponentChildList', ], 'componentType' => [ 'shape' => 'String', ], 'events' => [ 'shape' => 'ComponentEvents', ], 'name' => [ 'shape' => 'String', ], 'properties' => [ 'shape' => 'ComponentProperties', ], 'sourceId' => [ 'shape' => 'String', ], ], ], 'ComponentChildList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentChild', ], ], 'ComponentCollectionProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ComponentDataConfiguration', ], ], 'ComponentConditionProperty' => [ 'type' => 'structure', 'members' => [ 'else' => [ 'shape' => 'ComponentProperty', ], 'field' => [ 'shape' => 'String', ], 'operand' => [ 'shape' => 'String', ], 'operandType' => [ 'shape' => 'String', ], 'operator' => [ 'shape' => 'String', ], 'property' => [ 'shape' => 'String', ], 'then' => [ 'shape' => 'ComponentProperty', ], ], ], 'ComponentDataConfiguration' => [ 'type' => 'structure', 'required' => [ 'model', ], 'members' => [ 'identifiers' => [ 'shape' => 'IdentifierList', ], 'model' => [ 'shape' => 'String', ], 'predicate' => [ 'shape' => 'Predicate', ], 'sort' => [ 'shape' => 'SortPropertyList', ], ], ], 'ComponentEvent' => [ 'type' => 'structure', 'members' => [ 'action' => [ 'shape' => 'String', ], 'bindingEvent' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'ActionParameters', ], ], ], 'ComponentEvents' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ComponentEvent', ], ], 'ComponentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Component', ], ], 'ComponentName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'ComponentOverrides' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ComponentOverridesValue', ], ], 'ComponentOverridesValue' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'ComponentProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ComponentProperty', ], ], 'ComponentProperty' => [ 'type' => 'structure', 'members' => [ 'bindingProperties' => [ 'shape' => 'ComponentPropertyBindingProperties', ], 'bindings' => [ 'shape' => 'FormBindings', ], 'collectionBindingProperties' => [ 'shape' => 'ComponentPropertyBindingProperties', ], 'componentName' => [ 'shape' => 'String', ], 'concat' => [ 'shape' => 'ComponentPropertyList', ], 'condition' => [ 'shape' => 'ComponentConditionProperty', ], 'configured' => [ 'shape' => 'Boolean', 'box' => true, ], 'defaultValue' => [ 'shape' => 'String', ], 'event' => [ 'shape' => 'String', ], 'importedValue' => [ 'shape' => 'String', ], 'model' => [ 'shape' => 'String', ], 'property' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], 'userAttribute' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'ComponentPropertyBindingProperties' => [ 'type' => 'structure', 'required' => [ 'property', ], 'members' => [ 'field' => [ 'shape' => 'String', ], 'property' => [ 'shape' => 'String', ], ], ], 'ComponentPropertyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentProperty', ], ], 'ComponentSummary' => [ 'type' => 'structure', 'required' => [ 'appId', 'componentType', 'environmentName', 'id', 'name', ], 'members' => [ 'appId' => [ 'shape' => 'String', ], 'componentType' => [ 'shape' => 'ComponentType', ], 'environmentName' => [ 'shape' => 'String', ], 'id' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'ComponentName', ], ], ], 'ComponentSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentSummary', ], ], 'ComponentType' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'ComponentVariant' => [ 'type' => 'structure', 'members' => [ 'overrides' => [ 'shape' => 'ComponentOverrides', ], 'variantValues' => [ 'shape' => 'ComponentVariantValues', ], ], ], 'ComponentVariantValues' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'ComponentVariants' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComponentVariant', ], ], 'CreateComponentData' => [ 'type' => 'structure', 'required' => [ 'bindingProperties', 'componentType', 'name', 'overrides', 'properties', 'variants', ], 'members' => [ 'bindingProperties' => [ 'shape' => 'ComponentBindingProperties', ], 'children' => [ 'shape' => 'ComponentChildList', ], 'collectionProperties' => [ 'shape' => 'ComponentCollectionProperties', ], 'componentType' => [ 'shape' => 'ComponentType', ], 'events' => [ 'shape' => 'ComponentEvents', ], 'name' => [ 'shape' => 'ComponentName', ], 'overrides' => [ 'shape' => 'ComponentOverrides', ], 'properties' => [ 'shape' => 'ComponentProperties', ], 'schemaVersion' => [ 'shape' => 'String', ], 'sourceId' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'Tags', ], 'variants' => [ 'shape' => 'ComponentVariants', ], ], ], 'CreateComponentRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'componentToCreate', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'componentToCreate' => [ 'shape' => 'CreateComponentData', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], ], 'payload' => 'componentToCreate', ], 'CreateComponentResponse' => [ 'type' => 'structure', 'members' => [ 'entity' => [ 'shape' => 'Component', ], ], 'payload' => 'entity', ], 'CreateFormData' => [ 'type' => 'structure', 'required' => [ 'dataType', 'fields', 'formActionType', 'name', 'schemaVersion', 'sectionalElements', 'style', ], 'members' => [ 'cta' => [ 'shape' => 'FormCTA', ], 'dataType' => [ 'shape' => 'FormDataTypeConfig', ], 'fields' => [ 'shape' => 'FieldsMap', ], 'formActionType' => [ 'shape' => 'FormActionType', ], 'name' => [ 'shape' => 'FormName', ], 'schemaVersion' => [ 'shape' => 'String', ], 'sectionalElements' => [ 'shape' => 'SectionalElementMap', ], 'style' => [ 'shape' => 'FormStyle', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'CreateFormRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'formToCreate', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'formToCreate' => [ 'shape' => 'CreateFormData', ], ], 'payload' => 'formToCreate', ], 'CreateFormResponse' => [ 'type' => 'structure', 'members' => [ 'entity' => [ 'shape' => 'Form', ], ], 'payload' => 'entity', ], 'CreateThemeData' => [ 'type' => 'structure', 'required' => [ 'name', 'values', ], 'members' => [ 'name' => [ 'shape' => 'ThemeName', ], 'overrides' => [ 'shape' => 'ThemeValuesList', ], 'tags' => [ 'shape' => 'Tags', ], 'values' => [ 'shape' => 'ThemeValuesList', ], ], ], 'CreateThemeRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'themeToCreate', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'themeToCreate' => [ 'shape' => 'CreateThemeData', ], ], 'payload' => 'themeToCreate', ], 'CreateThemeResponse' => [ 'type' => 'structure', 'members' => [ 'entity' => [ 'shape' => 'Theme', ], ], 'payload' => 'entity', ], 'DeleteComponentRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'DeleteFormRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'DeleteThemeRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'ExchangeCodeForTokenRequest' => [ 'type' => 'structure', 'required' => [ 'provider', 'request', ], 'members' => [ 'provider' => [ 'shape' => 'TokenProviders', 'location' => 'uri', 'locationName' => 'provider', ], 'request' => [ 'shape' => 'ExchangeCodeForTokenRequestBody', ], ], 'payload' => 'request', ], 'ExchangeCodeForTokenRequestBody' => [ 'type' => 'structure', 'required' => [ 'code', 'redirectUri', ], 'members' => [ 'code' => [ 'shape' => 'SensitiveString', ], 'redirectUri' => [ 'shape' => 'String', ], ], ], 'ExchangeCodeForTokenResponse' => [ 'type' => 'structure', 'required' => [ 'accessToken', 'expiresIn', 'refreshToken', ], 'members' => [ 'accessToken' => [ 'shape' => 'SensitiveString', ], 'expiresIn' => [ 'shape' => 'Integer', 'box' => true, ], 'refreshToken' => [ 'shape' => 'SensitiveString', ], ], ], 'ExportComponentsRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ExportComponentsResponse' => [ 'type' => 'structure', 'required' => [ 'entities', ], 'members' => [ 'entities' => [ 'shape' => 'ComponentList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ExportFormsRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ExportFormsResponse' => [ 'type' => 'structure', 'required' => [ 'entities', ], 'members' => [ 'entities' => [ 'shape' => 'FormList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ExportThemesRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ExportThemesResponse' => [ 'type' => 'structure', 'required' => [ 'entities', ], 'members' => [ 'entities' => [ 'shape' => 'ThemeList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'FeaturesMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'FieldConfig' => [ 'type' => 'structure', 'members' => [ 'excluded' => [ 'shape' => 'Boolean', 'box' => true, ], 'inputType' => [ 'shape' => 'FieldInputConfig', ], 'label' => [ 'shape' => 'String', ], 'position' => [ 'shape' => 'FieldPosition', ], 'validations' => [ 'shape' => 'ValidationsList', ], ], ], 'FieldInputConfig' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'defaultChecked' => [ 'shape' => 'Boolean', 'box' => true, ], 'defaultCountryCode' => [ 'shape' => 'String', ], 'defaultValue' => [ 'shape' => 'String', ], 'descriptiveText' => [ 'shape' => 'String', ], 'maxValue' => [ 'shape' => 'Float', 'box' => true, ], 'minValue' => [ 'shape' => 'Float', 'box' => true, ], 'name' => [ 'shape' => 'String', ], 'placeholder' => [ 'shape' => 'String', ], 'readOnly' => [ 'shape' => 'Boolean', 'box' => true, ], 'required' => [ 'shape' => 'Boolean', 'box' => true, ], 'step' => [ 'shape' => 'Float', 'box' => true, ], 'type' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], 'valueMappings' => [ 'shape' => 'ValueMappings', ], ], ], 'FieldPosition' => [ 'type' => 'structure', 'members' => [ 'below' => [ 'shape' => 'String', ], 'fixed' => [ 'shape' => 'FixedPosition', ], 'rightOf' => [ 'shape' => 'String', ], ], 'union' => true, ], 'FieldValidationConfiguration' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'numValues' => [ 'shape' => 'NumValues', ], 'strValues' => [ 'shape' => 'StrValues', ], 'type' => [ 'shape' => 'String', ], 'validationMessage' => [ 'shape' => 'String', ], ], ], 'FieldsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'FieldConfig', ], ], 'FixedPosition' => [ 'type' => 'string', 'enum' => [ 'first', ], ], 'Float' => [ 'type' => 'float', ], 'Form' => [ 'type' => 'structure', 'required' => [ 'appId', 'dataType', 'environmentName', 'fields', 'formActionType', 'id', 'name', 'schemaVersion', 'sectionalElements', 'style', ], 'members' => [ 'appId' => [ 'shape' => 'String', ], 'cta' => [ 'shape' => 'FormCTA', ], 'dataType' => [ 'shape' => 'FormDataTypeConfig', ], 'environmentName' => [ 'shape' => 'String', ], 'fields' => [ 'shape' => 'FieldsMap', ], 'formActionType' => [ 'shape' => 'FormActionType', ], 'id' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'FormName', ], 'schemaVersion' => [ 'shape' => 'String', ], 'sectionalElements' => [ 'shape' => 'SectionalElementMap', ], 'style' => [ 'shape' => 'FormStyle', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'FormActionType' => [ 'type' => 'string', 'enum' => [ 'create', 'update', ], ], 'FormBindingElement' => [ 'type' => 'structure', 'required' => [ 'element', 'property', ], 'members' => [ 'element' => [ 'shape' => 'String', ], 'property' => [ 'shape' => 'String', ], ], ], 'FormBindings' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'FormBindingElement', ], ], 'FormButton' => [ 'type' => 'structure', 'members' => [ 'children' => [ 'shape' => 'String', ], 'excluded' => [ 'shape' => 'Boolean', 'box' => true, ], 'position' => [ 'shape' => 'FieldPosition', ], ], ], 'FormButtonsPosition' => [ 'type' => 'string', 'enum' => [ 'top', 'bottom', 'top_and_bottom', ], ], 'FormCTA' => [ 'type' => 'structure', 'members' => [ 'cancel' => [ 'shape' => 'FormButton', ], 'clear' => [ 'shape' => 'FormButton', ], 'position' => [ 'shape' => 'FormButtonsPosition', ], 'submit' => [ 'shape' => 'FormButton', ], ], ], 'FormDataSourceType' => [ 'type' => 'string', 'enum' => [ 'DataStore', 'Custom', ], ], 'FormDataTypeConfig' => [ 'type' => 'structure', 'required' => [ 'dataSourceType', 'dataTypeName', ], 'members' => [ 'dataSourceType' => [ 'shape' => 'FormDataSourceType', ], 'dataTypeName' => [ 'shape' => 'String', ], ], ], 'FormInputValueProperty' => [ 'type' => 'structure', 'members' => [ 'value' => [ 'shape' => 'String', ], ], ], 'FormList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Form', ], ], 'FormName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'FormStyle' => [ 'type' => 'structure', 'members' => [ 'horizontalGap' => [ 'shape' => 'FormStyleConfig', ], 'outerPadding' => [ 'shape' => 'FormStyleConfig', ], 'verticalGap' => [ 'shape' => 'FormStyleConfig', ], ], ], 'FormStyleConfig' => [ 'type' => 'structure', 'members' => [ 'tokenReference' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'union' => true, ], 'FormSummary' => [ 'type' => 'structure', 'required' => [ 'appId', 'dataType', 'environmentName', 'formActionType', 'id', 'name', ], 'members' => [ 'appId' => [ 'shape' => 'String', ], 'dataType' => [ 'shape' => 'FormDataTypeConfig', ], 'environmentName' => [ 'shape' => 'String', ], 'formActionType' => [ 'shape' => 'FormActionType', ], 'id' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'FormName', ], ], ], 'FormSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FormSummary', ], ], 'GetComponentRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'GetComponentResponse' => [ 'type' => 'structure', 'members' => [ 'component' => [ 'shape' => 'Component', ], ], 'payload' => 'component', ], 'GetFormRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'GetFormResponse' => [ 'type' => 'structure', 'members' => [ 'form' => [ 'shape' => 'Form', ], ], 'payload' => 'form', ], 'GetMetadataRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], ], ], 'GetMetadataResponse' => [ 'type' => 'structure', 'required' => [ 'features', ], 'members' => [ 'features' => [ 'shape' => 'FeaturesMap', ], ], ], 'GetThemeRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], ], ], 'GetThemeResponse' => [ 'type' => 'structure', 'members' => [ 'theme' => [ 'shape' => 'Theme', ], ], 'payload' => 'theme', ], 'IdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'Integer' => [ 'type' => 'integer', ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InvalidParameterException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ListComponentsLimit' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'ListComponentsRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'maxResults' => [ 'shape' => 'ListComponentsLimit', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListComponentsResponse' => [ 'type' => 'structure', 'required' => [ 'entities', ], 'members' => [ 'entities' => [ 'shape' => 'ComponentSummaryList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListFormsLimit' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'ListFormsRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'maxResults' => [ 'shape' => 'ListFormsLimit', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListFormsResponse' => [ 'type' => 'structure', 'required' => [ 'entities', ], 'members' => [ 'entities' => [ 'shape' => 'FormSummaryList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'ListThemesLimit' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'ListThemesRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'maxResults' => [ 'shape' => 'ListThemesLimit', 'box' => true, 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListThemesResponse' => [ 'type' => 'structure', 'required' => [ 'entities', ], 'members' => [ 'entities' => [ 'shape' => 'ThemeSummaryList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'MutationActionSetStateParameter' => [ 'type' => 'structure', 'required' => [ 'componentName', 'property', 'set', ], 'members' => [ 'componentName' => [ 'shape' => 'String', ], 'property' => [ 'shape' => 'String', ], 'set' => [ 'shape' => 'ComponentProperty', ], ], ], 'NumValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'Integer', ], ], 'Predicate' => [ 'type' => 'structure', 'members' => [ 'and' => [ 'shape' => 'PredicateList', ], 'field' => [ 'shape' => 'String', ], 'operand' => [ 'shape' => 'String', ], 'operator' => [ 'shape' => 'String', ], 'or' => [ 'shape' => 'PredicateList', ], ], ], 'PredicateList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Predicate', ], ], 'PutMetadataFlagBody' => [ 'type' => 'structure', 'required' => [ 'newValue', ], 'members' => [ 'newValue' => [ 'shape' => 'String', ], ], ], 'PutMetadataFlagRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'body', 'environmentName', 'featureName', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'body' => [ 'shape' => 'PutMetadataFlagBody', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'featureName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'featureName', ], ], 'payload' => 'body', ], 'RefreshTokenRequest' => [ 'type' => 'structure', 'required' => [ 'provider', 'refreshTokenBody', ], 'members' => [ 'provider' => [ 'shape' => 'TokenProviders', 'location' => 'uri', 'locationName' => 'provider', ], 'refreshTokenBody' => [ 'shape' => 'RefreshTokenRequestBody', ], ], 'payload' => 'refreshTokenBody', ], 'RefreshTokenRequestBody' => [ 'type' => 'structure', 'required' => [ 'token', ], 'members' => [ 'token' => [ 'shape' => 'SensitiveString', ], ], ], 'RefreshTokenResponse' => [ 'type' => 'structure', 'required' => [ 'accessToken', 'expiresIn', ], 'members' => [ 'accessToken' => [ 'shape' => 'SensitiveString', ], 'expiresIn' => [ 'shape' => 'Integer', 'box' => true, ], ], ], 'ResourceConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'SectionalElement' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'level' => [ 'shape' => 'Integer', 'box' => true, ], 'orientation' => [ 'shape' => 'String', ], 'position' => [ 'shape' => 'FieldPosition', ], 'text' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], ], ], 'SectionalElementMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'SectionalElement', ], ], 'SensitiveString' => [ 'type' => 'string', 'sensitive' => true, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SortDirection' => [ 'type' => 'string', 'enum' => [ 'ASC', 'DESC', ], ], 'SortProperty' => [ 'type' => 'structure', 'required' => [ 'direction', 'field', ], 'members' => [ 'direction' => [ 'shape' => 'SortDirection', ], 'field' => [ 'shape' => 'String', ], ], ], 'SortPropertyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SortProperty', ], ], 'StrValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'String' => [ 'type' => 'string', ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'Tags' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], 'Theme' => [ 'type' => 'structure', 'required' => [ 'appId', 'createdAt', 'environmentName', 'id', 'name', 'values', ], 'members' => [ 'appId' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'environmentName' => [ 'shape' => 'String', ], 'id' => [ 'shape' => 'Uuid', ], 'modifiedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'ThemeName', ], 'overrides' => [ 'shape' => 'ThemeValuesList', ], 'tags' => [ 'shape' => 'Tags', ], 'values' => [ 'shape' => 'ThemeValuesList', ], ], ], 'ThemeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Theme', ], ], 'ThemeName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'ThemeSummary' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', 'name', ], 'members' => [ 'appId' => [ 'shape' => 'String', ], 'environmentName' => [ 'shape' => 'String', ], 'id' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'ThemeName', ], ], ], 'ThemeSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ThemeSummary', ], ], 'ThemeValue' => [ 'type' => 'structure', 'members' => [ 'children' => [ 'shape' => 'ThemeValuesList', ], 'value' => [ 'shape' => 'String', ], ], ], 'ThemeValues' => [ 'type' => 'structure', 'members' => [ 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ThemeValue', ], ], ], 'ThemeValuesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ThemeValues', ], ], 'TokenProviders' => [ 'type' => 'string', 'enum' => [ 'figma', ], ], 'UnauthorizedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 401, 'senderFault' => true, ], 'exception' => true, ], 'UpdateComponentData' => [ 'type' => 'structure', 'members' => [ 'bindingProperties' => [ 'shape' => 'ComponentBindingProperties', ], 'children' => [ 'shape' => 'ComponentChildList', ], 'collectionProperties' => [ 'shape' => 'ComponentCollectionProperties', ], 'componentType' => [ 'shape' => 'ComponentType', ], 'events' => [ 'shape' => 'ComponentEvents', ], 'id' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'ComponentName', ], 'overrides' => [ 'shape' => 'ComponentOverrides', ], 'properties' => [ 'shape' => 'ComponentProperties', ], 'schemaVersion' => [ 'shape' => 'String', ], 'sourceId' => [ 'shape' => 'String', ], 'variants' => [ 'shape' => 'ComponentVariants', ], ], ], 'UpdateComponentRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', 'updatedComponent', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], 'updatedComponent' => [ 'shape' => 'UpdateComponentData', ], ], 'payload' => 'updatedComponent', ], 'UpdateComponentResponse' => [ 'type' => 'structure', 'members' => [ 'entity' => [ 'shape' => 'Component', ], ], 'payload' => 'entity', ], 'UpdateFormData' => [ 'type' => 'structure', 'members' => [ 'cta' => [ 'shape' => 'FormCTA', ], 'dataType' => [ 'shape' => 'FormDataTypeConfig', ], 'fields' => [ 'shape' => 'FieldsMap', ], 'formActionType' => [ 'shape' => 'FormActionType', ], 'name' => [ 'shape' => 'FormName', ], 'schemaVersion' => [ 'shape' => 'String', ], 'sectionalElements' => [ 'shape' => 'SectionalElementMap', ], 'style' => [ 'shape' => 'FormStyle', ], ], ], 'UpdateFormRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', 'updatedForm', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], 'updatedForm' => [ 'shape' => 'UpdateFormData', ], ], 'payload' => 'updatedForm', ], 'UpdateFormResponse' => [ 'type' => 'structure', 'members' => [ 'entity' => [ 'shape' => 'Form', ], ], 'payload' => 'entity', ], 'UpdateThemeData' => [ 'type' => 'structure', 'required' => [ 'values', ], 'members' => [ 'id' => [ 'shape' => 'Uuid', ], 'name' => [ 'shape' => 'ThemeName', ], 'overrides' => [ 'shape' => 'ThemeValuesList', ], 'values' => [ 'shape' => 'ThemeValuesList', ], ], ], 'UpdateThemeRequest' => [ 'type' => 'structure', 'required' => [ 'appId', 'environmentName', 'id', 'updatedTheme', ], 'members' => [ 'appId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'appId', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'environmentName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentName', ], 'id' => [ 'shape' => 'Uuid', 'location' => 'uri', 'locationName' => 'id', ], 'updatedTheme' => [ 'shape' => 'UpdateThemeData', ], ], 'payload' => 'updatedTheme', ], 'UpdateThemeResponse' => [ 'type' => 'structure', 'members' => [ 'entity' => [ 'shape' => 'Theme', ], ], 'payload' => 'entity', ], 'Uuid' => [ 'type' => 'string', ], 'ValidationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FieldValidationConfiguration', ], ], 'ValueMapping' => [ 'type' => 'structure', 'required' => [ 'value', ], 'members' => [ 'displayValue' => [ 'shape' => 'FormInputValueProperty', ], 'value' => [ 'shape' => 'FormInputValueProperty', ], ], ], 'ValueMappingList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValueMapping', ], ], 'ValueMappings' => [ 'type' => 'structure', 'required' => [ 'values', ], 'members' => [ 'values' => [ 'shape' => 'ValueMappingList', ], ], ], ],];
